<?php
/**
 * Veidotājs: Roberts Blite
 * Mērķis: Materiālu pārvaldības skripts - pievienošana, atjaunināšana, dzēšana, eksportēšana.
 * Apraksts: Skripts apstrādā materiālu pievienošanu, atjaunināšanu un noņemšanu,
 *           kā arī sniedz iespēju eksportēt materiālus CSV formātā.
 */

// Datubāzes savienojuma parametri
$servername = "database-1.cd0m46mqkm83.eu-north-1.rds.amazonaws.com";
$username = "admin";
$password = "HyperX3146!";
$dbname = "rb_kvalif_410";

// Izveido datubāzes savienojumu
$conn = new mysqli($servername, $username, $password, $dbname);

// Pārbauda savienojumu
if ($conn->connect_error) {
    die(json_encode(["error" => "Datubāzes savienojums neizdevās: " . $conn->connect_error]));
}

header('Content-Type: application/json'); // Iestata atbildes tipu kā JSON

/**
 * Funkcija, kas nosaka materiāla statusu pēc skaita
 */
function getStatus($count) {
    if ($count <= 0) return "Beidzies";
    if ($count < 10) return "Mazāk par normu";
    return "Pietiekami";
}

// Pievienot materiālu
if ($_SERVER['REQUEST_METHOD'] === 'POST' && isset($_GET['action']) && $_GET['action'] === 'add') {
    $data = json_decode(file_get_contents('php://input'), true);

    if (isset($data['sku_code'], $data['material_type'], $data['material_size'], $data['material_count'])) {
        $sku_code = $conn->real_escape_string($data['sku_code']);
        $material_type = $conn->real_escape_string($data['material_type']);
        $material_size = $conn->real_escape_string($data['material_size']);
        $material_count = intval($data['material_count']);

        // Pārbauda, vai materiāls jau eksistē
        $check_sql = "SELECT material_count FROM rb_kvalif_materialcount_410 WHERE sku_code = '$sku_code'";
        $result = $conn->query($check_sql);

        if ($result && $result->num_rows > 0) {
            // Atjaunina esošo materiālu
            $row = $result->fetch_assoc();
            $new_count = $row['material_count'] + $material_count;
            $status = getStatus($new_count);

            $update_sql = "UPDATE rb_kvalif_materialcount_410 
                           SET material_count = $new_count, status = '$status'
                           WHERE sku_code = '$sku_code'";
            if ($conn->query($update_sql) === TRUE) {
                echo json_encode(["success" => "Materiāla daudzums veiksmīgi atjaunināts."]);
            } else {
                echo json_encode(["error" => "Neizdevās atjaunināt materiālu: " . $conn->error]);
            }
        } else {
            // Pievieno jaunu materiālu
            $status = getStatus($material_count);
            $insert_sql = "INSERT INTO rb_kvalif_materialcount_410 (sku_code, material_type, material_size, material_count, status)
                           VALUES ('$sku_code', '$material_type', '$material_size', $material_count, '$status')";
            if ($conn->query($insert_sql) === TRUE) {
                echo json_encode(["success" => "Materiāls veiksmīgi pievienots."]);
            } else {
                echo json_encode(["error" => "Neizdevās pievienot materiālu: " . $conn->error]);
            }
        }
    } else {
        echo json_encode(["error" => "Nepareizi dati."]);
    }
    exit;
}

// Noņemt materiālu
if ($_SERVER['REQUEST_METHOD'] === 'POST' && isset($_GET['action']) && $_GET['action'] === 'remove') {
    $data = json_decode(file_get_contents('php://input'), true);

    if (isset($data['sku_code'], $data['remove_count'])) {
        $sku_code = $conn->real_escape_string($data['sku_code']);
        $remove_count = intval($data['remove_count']);

        $sql = "SELECT material_count FROM rb_kvalif_materialcount_410 WHERE sku_code = '$sku_code'";
        $result = $conn->query($sql);

        if ($result && $result->num_rows > 0) {
            $row = $result->fetch_assoc();
            $new_count = max(0, $row['material_count'] - $remove_count); // Nodrošina, ka skaits nav negatīvs
            $status = getStatus($new_count);

            $update_sql = "UPDATE rb_kvalif_materialcount_410 SET material_count = $new_count, status = '$status' WHERE sku_code = '$sku_code'";
            if ($conn->query($update_sql) === TRUE) {
                echo json_encode(["success" => "Materiāla daudzums veiksmīgi atjaunināts."]);
            } else {
                echo json_encode(["error" => "Neizdevās atjaunināt materiālu: " . $conn->error]);
            }
        } else {
            echo json_encode(["error" => "Materiāls netika atrasts."]);
        }
    } else {
        echo json_encode(["error" => "Nepareizi dati."]);
    }
    exit;
}

// Iegūt materiālu sarakstu
if ($_SERVER['REQUEST_METHOD'] === 'GET' && !isset($_GET['export'])) {
    $sql = "SELECT sku_code, material_type, material_size, material_count, status FROM rb_kvalif_materialcount_410";
    $result = $conn->query($sql);

    if ($result && $result->num_rows > 0) {
        $materials = [];
        while ($row = $result->fetch_assoc()) {
            $materials[] = $row;
        }
        echo json_encode($materials);
    } else {
        echo json_encode([]);
    }
    exit;
}

// Eksportēt materiālus kā CSV
if ($_SERVER['REQUEST_METHOD'] === 'GET' && isset($_GET['export']) && $_GET['export'] === 'csv') {
    $sql = "SELECT * FROM rb_kvalif_materialcount_410";
    $result = $conn->query($sql);

    header('Content-Type: text/csv');
    header('Content-Disposition: attachment;filename=materials.csv');

    $output = fopen("php://output", "w");
    fputcsv($output, ['SKU kods', 'Materiāla tips', 'Materiāla izmērs', 'Materiāla skaits', 'Statuss']);

    if ($result && $result->num_rows > 0) {
        while ($row = $result->fetch_assoc()) {
            fputcsv($output, $row);
        }
    }
    fclose($output);
    exit;
}

// Aizver datubāzes savienojumu
$conn->close();
?>
